#version 430 core

layout ( triangles ) in;
layout ( triangle_strip, max_vertices = 3) out;

//inputs

layout (location = 0) in vec2  geoTexCoords[];
layout (location = 1) in vec3  geoPosition[];
layout (location = 2) in vec3  geoNormal[];
layout (location = 3) in float  geoD[];

layout(binding = 0, rgba32f) uniform readonly restrict image2D inputTex;

 //outputs
layout (location = 0) out vec3 fragNormal;
layout (location = 1) out vec2  fragTexCoords;
layout (location = 2) out vec4  fragViewPos;
layout (location = 3) out float fragD;

uniform mat4 view;
uniform mat4 MVP;
uniform mat3 transInverseView;
uniform vec3 worldPos;

vec3 calculateNormal(int location){

	int primary;
	int secondary;
	int tertiary;

	if(location == 0){
		primary = 0;
		secondary = 1;
		tertiary = 2;
	}else if(location == 1){
		primary = 1;
		secondary = 2;
		tertiary = 0;
	}else if(location == 2){
		primary = 2;
		secondary = 0;
		tertiary = 1;
	}

	vec3 tangent = geoPosition[secondary].xyz - geoPosition[primary].xyz;
	vec3 bitangent = geoPosition[tertiary].xyz - geoPosition[primary].xyz;
	vec3 normal = cross(tangent, bitangent);	

	vec3 normalizedNormal = normalize(normal);

	mat3 normalMatrix = transInverseView;

	return normalize(normalMatrix * normalizedNormal);
}

void main(void){
		
	vec3 normal;

	vec4 viewPosition;
	vec4 inputPosition;


	inputPosition = vec4(geoPosition[0] + worldPos, 1.0);
	viewPosition = view * inputPosition;
	gl_Position = MVP * inputPosition;
	fragViewPos = viewPosition;
	fragNormal = calculateNormal(0);
	fragTexCoords = geoTexCoords[0];
	fragD = geoD[0];
	EmitVertex();

	inputPosition = vec4(geoPosition[1] + worldPos, 1.0);
	viewPosition = view * inputPosition;
	gl_Position = MVP * inputPosition;
	fragViewPos = viewPosition;
	fragNormal = calculateNormal(1);
	fragTexCoords = geoTexCoords[1];
	fragD = geoD[1];
	EmitVertex();

	inputPosition = vec4(geoPosition[2] + worldPos, 1.0);
	viewPosition = view * inputPosition;
	gl_Position = MVP * inputPosition;
	fragViewPos = viewPosition;
	fragNormal = calculateNormal(2);
	fragTexCoords = geoTexCoords[2];
	fragD = geoD[2];
	EmitVertex();
	
	EndPrimitive();

}